//
//  OPAESKey.h
//  OnePasswordiOS
//
//  Created by Roustem Karimov on 2012-05-21.
//  Copyright (c) 2012 AgileBits. All rights reserved.
//

#import <Foundation/Foundation.h>

#define OPBlockSizeAES128 16
#define OPSHA256_DIGEST_LENGTH 32
#define OPAESKeySize 32 /*kCCKeySizeAES256*/
#define OPEncryptedAESKeySize (OPBlockSizeAES128/*kCCBlockSizeAES128*/ + OPAESKeySize/*kCCKeySizeAES256*/ + OPAESKeySize/*kCCKeySizeAES256*/ + OPSHA256_DIGEST_LENGTH/*CC_SHA256_DIGEST_LENGTH*/)

typedef struct {
	uint8_t encryptionKey[OPAESKeySize];
	uint8_t hmacKey[OPAESKeySize];
} OPAESRawKey;

FOUNDATION_EXTERN NSString *const OPAESHeaderMagicBase64;
FOUNDATION_EXTERN NSString *const OPAESHeaderMagic;

@interface OPAESKey : NSObject

@property (nonatomic) size_t bufferSize;

+ (uint)calibrateForPassword:(NSString *)password salt:(NSData *)salt;

- (NSString *)description;

/**
 * Generate new random key
 */
- (id)initWithRandomKey;

/**
 * Expecting rawKey with fixed size ("OPAESKeySize" bytes)
 */
- (id)initWithRawKey:(OPAESRawKey *)rawKey;

/**
 * Will generate raw key using variable length keyData
 */
- (id)initWithKeyData:(NSData *)keyData;

/**
 * Use PBKDF2 to create the raw key.
 */
- (id)initWithPassword:(NSString *)password salt:(NSData *)salt iterations:(NSUInteger)iterations;

- (const OPAESRawKey *)rawKey;
- (NSData *)rawKeyData;

- (BOOL)encryptDataOfLength:(size_t)dataLength reader:(NSData *(^)(size_t bytesToRead))reader writer:(void (^)(NSData *encrypted))writer error:(NSError **)error;
- (BOOL)decryptDataWithReader:(NSData *(^)(size_t bytesToRead))reader writer:(void (^)(NSData *plaintext))writer error:(NSError **)error;


- (NSData *)encrypt:(NSData *)data;
- (NSData *)decrypt:(NSData *)data;

- (NSData *)encryptKey:(OPAESKey *)key;
- (OPAESKey *)decryptKey:(NSData *)keyData;

- (BOOL)isEqualToAESKey:(OPAESKey *)anotherKey;

@end
